<?php
/*--------------------------------------------------------------------
 ReadService.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Service;

use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO\AttributeWeightDtoCollection;
use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\RepositoryInterface;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function attributeWeights(ModifierIdentifierCollectionInterface $modifiers): AttributeWeightDtoCollection
    {
        return $this->repository->attributeWeights($modifiers);
    }
}